/**
 * customizer.js
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );
	
	//news title
	wp.customize(
		'shopbiz_news_title', function( value ) {
			value.bind(
				function( newval ) {
					$( '.ta-blog-section .shopbiz-heading h3' ).text( newval );
				}
			);
		}
	);
	
	//news description
	wp.customize(
		'shopbiz_news_subtitle', function( value ) {
			value.bind(
				function( newval ) {
					$( '.ta-blog-section .shopbiz-heading p' ).text( newval );
				}
			);
		}
	);
	
	
	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );
} )( jQuery );
